package gov.va.genisis2.ts.dto;

import java.io.Serializable;
import java.util.List;

public class ConceptCardDTO implements Serializable {

	private static final long serialVersionUID = 6486930749651879676L;

	private String name;
	private String nameWithOntologyName;
	private String ontologyName;
	private String uri;
	private ConceptDescriptionDTO description;
	private List<ConceptPredicateUriValueDTO> definitions;
	private List<ConceptPredicateUriValueDTO> altDefinitions;
	private List<ConceptPredicateUriValueDTO> synonyms;
	private ConceptRelationshipDTO relationships;
	private List<RelationshipClassTypeDTO> superClasses;
	private List<RelationshipClassTypeDTO> subClasses;
	private ConceptCardMetaDTO meta;
	private List<MetaInterOntologyLinkDTO> interOntologyLinks;
	private List<MetaPropertyDTO> properties;
	private List<MetaRelationshipDTO> metaRelationships;
	private ConceptPredicateUriValueDTO algorithm;
	private ConceptPredicateUriValueDTO validation;
	private List<ConceptPredicateUriValueDTO> dataElements;
	private String guid;
	private String source;
	private String definition;
	private String dataOutcome;
	private String dataTransformation;
	private String cleaned;
	private String cleaningProcedure;
	private String dataSource;
	private MetaPropertyDTO elementType;
	private MetaPropertyDTO type;
	private String sensitivity;
	private String specificity;
	private String units;
	private String validatedBy;
	private MetaPropertyDTO notation;
	private MetaPropertyDTO cbaseCode;
	private MetaPropertyDTO comment;
	private List<MetaPropertyDTO> genesAssociatedWithDiseases;
	private MetaPropertyDTO questionText;
	private MetaPropertyDTO questionNumber;

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the nameWithOntologyName
	 */
	public String getNameWithOntologyName() {
		return nameWithOntologyName;
	}

	/**
	 * @param nameWithOntologyName
	 *            the nameWithOntologyName to set
	 */
	public void setNameWithOntologyName(String nameWithOntologyName) {
		this.nameWithOntologyName = nameWithOntologyName;
	}

	/**
	 * @return the ontologyName
	 */
	public String getOntologyName() {
		return ontologyName;
	}

	/**
	 * @param ontologyName
	 *            the ontologyName to set
	 */
	public void setOntologyName(String ontologyName) {
		this.ontologyName = ontologyName;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @param uri
	 *            the uri to set
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return the description
	 */
	public ConceptDescriptionDTO getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(ConceptDescriptionDTO description) {
		this.description = description;
	}

	/**
	 * @return the definitions
	 */
	public List<ConceptPredicateUriValueDTO> getDefinitions() {
		return definitions;
	}

	/**
	 * @param definitions
	 *            the definitions to set
	 */
	public void setDefinitions(List<ConceptPredicateUriValueDTO> definitions) {
		this.definitions = definitions;
	}

	/**
	 * @return the altDefinitions
	 */
	public List<ConceptPredicateUriValueDTO> getAltDefinitions() {
		return altDefinitions;
	}

	/**
	 * @param altDefinitions
	 *            the altDefinitions to set
	 */
	public void setAltDefinitions(List<ConceptPredicateUriValueDTO> altDefinitions) {
		this.altDefinitions = altDefinitions;
	}

	/**
	 * @return the synonyms
	 */
	public List<ConceptPredicateUriValueDTO> getSynonyms() {
		return synonyms;
	}

	/**
	 * @param synonyms
	 *            the synonyms to set
	 */
	public void setSynonyms(List<ConceptPredicateUriValueDTO> synonyms) {
		this.synonyms = synonyms;
	}

	/**
	 * @return the relationships
	 */
	public ConceptRelationshipDTO getRelationships() {
		return relationships;
	}

	/**
	 * @param relationships
	 *            the relationships to set
	 */
	public void setRelationships(ConceptRelationshipDTO relationships) {
		this.relationships = relationships;
	}

	/**
	 * @return the superClasses
	 */
	public List<RelationshipClassTypeDTO> getSuperClasses() {
		return superClasses;
	}

	/**
	 * @param superClasses
	 *            the superClasses to set
	 */
	public void setSuperClasses(List<RelationshipClassTypeDTO> superClasses) {
		this.superClasses = superClasses;
	}

	/**
	 * @return the subClasses
	 */
	public List<RelationshipClassTypeDTO> getSubClasses() {
		return subClasses;
	}

	/**
	 * @param subClasses
	 *            the subClasses to set
	 */
	public void setSubClasses(List<RelationshipClassTypeDTO> subClasses) {
		this.subClasses = subClasses;
	}

	/**
	 * @return the meta
	 */
	public ConceptCardMetaDTO getMeta() {
		return meta;
	}

	/**
	 * @param meta
	 *            the meta to set
	 */
	public void setMeta(ConceptCardMetaDTO meta) {
		this.meta = meta;
	}

	/**
	 * @return the interOntologyLinks
	 */
	public List<MetaInterOntologyLinkDTO> getInterOntologyLinks() {
		return interOntologyLinks;
	}

	/**
	 * @param interOntologyLinks
	 *            the interOntologyLinks to set
	 */
	public void setInterOntologyLinks(List<MetaInterOntologyLinkDTO> interOntologyLinks) {
		this.interOntologyLinks = interOntologyLinks;
	}

	/**
	 * @return the properties
	 */
	public List<MetaPropertyDTO> getProperties() {
		return properties;
	}

	/**
	 * @param properties
	 *            the properties to set
	 */
	public void setProperties(List<MetaPropertyDTO> properties) {
		this.properties = properties;
	}

	/**
	 * @return the metaRelationships
	 */
	public List<MetaRelationshipDTO> getMetaRelationships() {
		return metaRelationships;
	}

	/**
	 * @param metaRelationships
	 *            the metaRelationships to set
	 */
	public void setMetaRelationships(List<MetaRelationshipDTO> metaRelationships) {
		this.metaRelationships = metaRelationships;
	}

	/**
	 * @return the algorithm
	 */
	public ConceptPredicateUriValueDTO getAlgorithm() {
		return algorithm;
	}

	/**
	 * @param algorithm
	 *            the algorithm to set
	 */
	public void setAlgorithm(ConceptPredicateUriValueDTO algorithm) {
		this.algorithm = algorithm;
	}

	/**
	 * @return the validation
	 */
	public ConceptPredicateUriValueDTO getValidation() {
		return validation;
	}

	/**
	 * @param validation
	 *            the validation to set
	 */
	public void setValidation(ConceptPredicateUriValueDTO validation) {
		this.validation = validation;
	}

	/**
	 * @return the dataElements
	 */
	public List<ConceptPredicateUriValueDTO> getDataElements() {
		return dataElements;
	}

	/**
	 * @param dataElements
	 *            the dataElements to set
	 */
	public void setDataElements(List<ConceptPredicateUriValueDTO> dataElements) {
		this.dataElements = dataElements;
	}

	/**
	 * @return the guid
	 */
	public String getGuid() {
		return guid;
	}

	/**
	 * @param guid
	 *            the guid to set
	 */
	public void setGuid(String guid) {
		this.guid = guid;
	}

	/**
	 * @return the source
	 */
	public String getSource() {
		return source;
	}

	/**
	 * @param source
	 *            the source to set
	 */
	public void setSource(String source) {
		this.source = source;
	}

	/**
	 * @return the definition
	 */
	public String getDefinition() {
		return definition;
	}

	/**
	 * @param definition
	 *            the definition to set
	 */
	public void setDefinition(String definition) {
		this.definition = definition;
	}

	/**
	 * @return the dataOutcome
	 */
	public String getDataOutcome() {
		return dataOutcome;
	}

	/**
	 * @param dataOutcome
	 *            the dataOutcome to set
	 */
	public void setDataOutcome(String dataOutcome) {
		this.dataOutcome = dataOutcome;
	}

	/**
	 * @return the dataTransformation
	 */
	public String getDataTransformation() {
		return dataTransformation;
	}

	/**
	 * @param dataTransformation
	 *            the dataTransformation to set
	 */
	public void setDataTransformation(String dataTransformation) {
		this.dataTransformation = dataTransformation;
	}

	/**
	 * @return the cleaned
	 */
	public String getCleaned() {
		return cleaned;
	}

	/**
	 * @param cleaned
	 *            the cleaned to set
	 */
	public void setCleaned(String cleaned) {
		this.cleaned = cleaned;
	}

	/**
	 * @return the cleaningProcedure
	 */
	public String getCleaningProcedure() {
		return cleaningProcedure;
	}

	/**
	 * @param cleaningProcedure
	 *            the cleaningProcedure to set
	 */
	public void setCleaningProcedure(String cleaningProcedure) {
		this.cleaningProcedure = cleaningProcedure;
	}

	/**
	 * @return the dataSource
	 */
	public String getDataSource() {
		return dataSource;
	}

	/**
	 * @param dataSource
	 *            the dataSource to set
	 */
	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}

	/**
	 * @return the elementType
	 */
	public MetaPropertyDTO getElementType() {
		return elementType;
	}

	/**
	 * @param elementType
	 *            the elementType to set
	 */
	public void setElementType(MetaPropertyDTO elementType) {
		this.elementType = elementType;
	}

	/**
	 * @return the type
	 */
	public MetaPropertyDTO getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(MetaPropertyDTO type) {
		this.type = type;
	}

	/**
	 * @return the sensitivity
	 */
	public String getSensitivity() {
		return sensitivity;
	}

	/**
	 * @param sensitivity
	 *            the sensitivity to set
	 */
	public void setSensitivity(String sensitivity) {
		this.sensitivity = sensitivity;
	}

	/**
	 * @return the specificity
	 */
	public String getSpecificity() {
		return specificity;
	}

	/**
	 * @param specificity
	 *            the specificity to set
	 */
	public void setSpecificity(String specificity) {
		this.specificity = specificity;
	}

	/**
	 * @return the units
	 */
	public String getUnits() {
		return units;
	}

	/**
	 * @param units
	 *            the units to set
	 */
	public void setUnits(String units) {
		this.units = units;
	}

	/**
	 * @return the validatedBy
	 */
	public String getValidatedBy() {
		return validatedBy;
	}

	/**
	 * @param validatedBy
	 *            the validatedBy to set
	 */
	public void setValidatedBy(String validatedBy) {
		this.validatedBy = validatedBy;
	}

	/**
	 * @return the notation
	 */
	public MetaPropertyDTO getNotation() {
		return notation;
	}

	/**
	 * @param notation
	 *            the notation to set
	 */
	public void setNotation(MetaPropertyDTO notation) {
		this.notation = notation;
	}

	/**
	 * @return the cbaseCode
	 */
	public MetaPropertyDTO getCbaseCode() {
		return cbaseCode;
	}

	/**
	 * @param cbaseCode
	 *            the cbaseCode to set
	 */
	public void setCbaseCode(MetaPropertyDTO cbaseCode) {
		this.cbaseCode = cbaseCode;
	}

	/**
	 * @return the comment
	 */
	public MetaPropertyDTO getComment() {
		return comment;
	}

	/**
	 * @param comment
	 *            the comment to set
	 */
	public void setComment(MetaPropertyDTO comment) {
		this.comment = comment;
	}

	/**
	 * @return the genesAssociatedWithDiseases
	 */
	public List<MetaPropertyDTO> getGenesAssociatedWithDiseases() {
		return genesAssociatedWithDiseases;
	}

	/**
	 * @param genesAssociatedWithDiseases
	 *            the genesAssociatedWithDiseases to set
	 */
	public void setGenesAssociatedWithDiseases(List<MetaPropertyDTO> genesAssociatedWithDiseases) {
		this.genesAssociatedWithDiseases = genesAssociatedWithDiseases;
	}

	/**
	 * @return the questionText
	 */
	public MetaPropertyDTO getQuestionText() {
		return questionText;
	}

	/**
	 * @param questionText
	 *            the questionText to set
	 */
	public void setQuestionText(MetaPropertyDTO questionText) {
		this.questionText = questionText;
	}

	/**
	 * @return the questionNumber
	 */
	public MetaPropertyDTO getQuestionNumber() {
		return questionNumber;
	}

	/**
	 * @param questionNumber
	 *            the questionNumber to set
	 */
	public void setQuestionNumber(MetaPropertyDTO questionNumber) {
		this.questionNumber = questionNumber;
	}
}
